import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a new figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Define colors for statuses
colors = {'clear': 'green', 'supporting': 'red', 'held': 'blue'}

# Define block positions and sizes
block_width, block_height = 1, 0.5
table_height = 0.3
hand_radius = 0.25

# Draw the table
table = patches.Rectangle((0, 0), 6, table_height, linewidth=1, edgecolor='black', facecolor='lightgray')
ax.add_patch(table)

# Draw the blocks
blocks = {
    'a': (4, table_height + block_height, 'clear'),  # on block d
    'b': (1, table_height, 'clear'),  # on table
    'c': (2.5, table_height, 'clear'),  # on table
    'd': (4, table_height, 'supporting')  # on table
}

for block, (x, y, status) in blocks.items():
    rect = patches.Rectangle((x, y), block_width, block_height, linewidth=1,
                             edgecolor='black', facecolor=colors[status])
    ax.add_patch(rect)
    ax.text(x + block_width / 2, y + block_height / 2, f'{block}\n{status}',
            horizontalalignment='center', verticalalignment='center', fontsize=9, color='white')

# Draw the hand
hand = patches.Circle((3, table_height + 2 * block_height + hand_radius * 2), hand_radius,
                      linewidth=1, edgecolor='black', facecolor='blue')
ax.add_patch(hand)
ax.text(3, table_height + 2 * block_height + hand_radius * 2, 'hand\nempty',
        horizontalalignment='center', verticalalignment='center', fontsize=9, color='white')

# Create a legend
legend_patches = [
    patches.Patch(color='green', label='Clear'),
    patches.Patch(color='red', label='Supporting'),
    patches.Patch(color='blue', label='Held')
]
plt.legend(handles=legend_patches, loc='upper right', bbox_to_anchor=(1.1, 1))

# Set limits and aspect
ax.set_xlim(-1, 7)
ax.set_ylim(-0.5, 3)
ax.set_aspect('equal')
ax.axis('off')

# Save the figure
plt.savefig('<PATH_REMOVED>', bbox_inches='tight')
plt.show()